#include "core.h"
#include "master.h"
#include "process.h"
#include <stdio.h>
#include "host.h"
SRCFILE("main.c")

extern "C" {
	extern char version[];
}

void ErrExit(char *e)
{
	fprintf(stderr, "%s\n", e);
	exit(1);
}

char *TAPTO;
char *PATH;
char *SRCPATH;

void PadsRemInit();
char *PadsTermInit(int, char**, char*);

void LoadTerm(int argc, char **av)
{
	if (av[1] && !strcmp(av[1],"-R")) {
		PadsRemInit();
		return;
	}
	if (av[1] && !strcmp(av[1],"-r") && av[2])
		ErrExit(PadsTermInit(argc, av, av[2]));
	if( PadsInit(argc, av) )
		ErrExit("cannot load terminal");
}

void DoBatch(int argc, char **av)
{
	char *core = "core", *aout = "a.out";
	if (argc--) core = *av++;
	if (argc) aout = *av++;
	new HostProcess(0, core, aout, 0)->batch();
	exit(0);
}

void main(int argc, char **av)
{
	PATH = getenv("PATH");
	SRCPATH = getenv("PI_SRCPATH");
	if (argc == 2 && !strcmp(av[1],"-V")) {
		printf(version);
		exit(0);
	}
	if (argc >= 2 && !strcmp(av[1],"-t"))
		DoBatch(argc - 2, av + 2);
	::signal(SIGCLD, SIG_IGN);
	LoadTerm(argc, av);
	extern char *TapTo;
	TapTo = TAPTO;
	NewHelp();
	NewWd();
	new HostMaster();
	PadsServe();
}
